/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sdp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.peers.sdp.Codec;
import net.sourceforge.peers.sdp.MediaDescription;
import net.sourceforge.peers.sdp.SdpLine;
import net.sourceforge.peers.sdp.SessionDescription;

public class SdpParser {
    public SessionDescription parse(byte[] body) throws IOException {
        if (body == null || body.length == 0) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(body);
        InputStreamReader inputStreamReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        SessionDescription sessionDescription = new SessionDescription();
        String line = reader.readLine();
        if (line.length() < 3) {
            return null;
        }
        if (line.charAt(0) != 'v' || line.charAt(1) != '=' || line.charAt(2) != '0') {
            return null;
        }
        line = reader.readLine();
        if (line.length() < 3) {
            return null;
        }
        if (line.charAt(0) != 'o' || line.charAt(1) != '=') {
            return null;
        }
        String[] originArr = (line = line.substring(2)).split(" ");
        if (originArr == null || originArr.length != 6) {
            return null;
        }
        sessionDescription.setUsername(originArr[0]);
        sessionDescription.setId(Long.parseLong(originArr[1]));
        sessionDescription.setVersion(Long.parseLong(originArr[2]));
        sessionDescription.setIpAddress(InetAddress.getByName(originArr[5]));
        line = reader.readLine();
        if (line.length() < 3) {
            return null;
        }
        if (line.charAt(0) != 's' || line.charAt(1) != '=') {
            return null;
        }
        sessionDescription.setName(line.substring(2));
        Hashtable<String, String> sessionAttributes = new Hashtable<String, String>();
        sessionDescription.setAttributes(sessionAttributes);
        while ((line = reader.readLine()) != null && line.charAt(0) != 'm') {
            if (line.length() > 3 && line.charAt(0) == 'c' && line.charAt(1) == '=') {
                String connection = this.parseConnection(line.substring(2));
                if (connection == null) continue;
                sessionDescription.setIpAddress(InetAddress.getByName(connection));
                continue;
            }
            if (line.length() <= 3 || line.charAt(0) != 'a' || line.charAt(1) != '=') continue;
            String value = line.substring(2);
            int pos = value.indexOf(58);
            if (pos > -1) {
                sessionAttributes.put(value.substring(0, pos), value.substring(pos + 1));
                continue;
            }
            sessionAttributes.put(value, "");
        }
        if (line == null) {
            return null;
        }
        ArrayList<SdpLine> mediaLines = new ArrayList<SdpLine>();
        do {
            if (line.length() < 3) {
                return null;
            }
            if (line.charAt(1) != '=') {
                return null;
            }
            SdpLine mediaLine = new SdpLine();
            mediaLine.setType(line.charAt(0));
            mediaLine.setValue(line.substring(2));
            mediaLines.add(mediaLine);
        } while ((line = reader.readLine()) != null);
        ArrayList<MediaDescription> mediaDescriptions = new ArrayList<MediaDescription>();
        sessionDescription.setMediaDescriptions(mediaDescriptions);
        block8: for (SdpLine sdpLine : mediaLines) {
            MediaDescription mediaDescription;
            if (sdpLine.getType() == 'm') {
                String[] mediaArr = sdpLine.getValue().split(" ");
                if (mediaArr == null || mediaArr.length < 4) {
                    return null;
                }
                mediaDescription = new MediaDescription();
                mediaDescription.setType(mediaArr[0]);
                mediaDescription.setPort(Integer.parseInt(mediaArr[1]));
                mediaDescription.setAttributes(new Hashtable<String, String>());
                ArrayList<Codec> codecs = new ArrayList<Codec>();
                for (int i = 3; i < mediaArr.length; ++i) {
                    String name;
                    int payloadType = Integer.parseInt(mediaArr[i]);
                    Codec codec = new Codec();
                    codec.setPayloadType(payloadType);
                    switch (payloadType) {
                        case 0: {
                            name = "PCMU";
                            break;
                        }
                        case 8: {
                            name = "PCMA";
                            break;
                        }
                        default: {
                            name = "unsupported";
                        }
                    }
                    codec.setName(name);
                    codecs.add(codec);
                }
                mediaDescription.setCodecs(codecs);
                mediaDescriptions.add(mediaDescription);
                continue;
            }
            mediaDescription = mediaDescriptions.get(mediaDescriptions.size() - 1);
            String sdpLineValue = sdpLine.getValue();
            if (sdpLine.getType() == 'c') {
                String ipAddress = this.parseConnection(sdpLineValue);
                mediaDescription.setIpAddress(InetAddress.getByName(ipAddress));
                continue;
            }
            if (sdpLine.getType() != 'a') continue;
            Hashtable<String, String> attributes = mediaDescription.getAttributes();
            int pos = sdpLineValue.indexOf(58);
            if (pos > -1) {
                String name = sdpLineValue.substring(0, pos);
                String value = sdpLineValue.substring(pos + 1);
                if ((pos = value.indexOf(" ")) > -1) {
                    try {
                        int payloadType = Integer.parseInt(value.substring(0, pos));
                        List<Codec> codecs = mediaDescription.getCodecs();
                        for (Codec codec : codecs) {
                            if (codec.getPayloadType() != payloadType) continue;
                            if ((pos = (value = value.substring(pos + 1)).indexOf("/")) <= -1) continue block8;
                            value = value.substring(0, pos);
                            codec.setName(value);
                        }
                    }
                    catch (NumberFormatException e) {
                        attributes.put(name, value);
                    }
                    continue;
                }
                attributes.put(name, value);
                continue;
            }
            attributes.put(sdpLineValue, "");
        }
        sessionDescription.setMediaDescriptions(mediaDescriptions);
        for (MediaDescription description : mediaDescriptions) {
            if (description.getIpAddress() != null) continue;
            InetAddress sessionAddress = sessionDescription.getIpAddress();
            if (sessionAddress == null) {
                return null;
            }
            description.setIpAddress(sessionAddress);
        }
        return sessionDescription;
    }

    private String parseConnection(String line) {
        String[] connectionArr = line.split(" ");
        if (connectionArr == null || connectionArr.length != 3) {
            return null;
        }
        return connectionArr[2];
    }
}

